ORCA/M Asm65816 2.1.0

0001 6124                       title 'LineEditProc'
0002 6124              **********************************************************************
0003 6124              *
0004 6124              * LineEdit Control Def Proc
0005 6124              *
0006 6124              *
0007 6124              * Copyright (C)
0008 6124              * Apple Computer, Inc.  1986-1989
0009 6124              * All Rights Reserved
0010 6124              *
0011 6124              * 24 Sep 88         Steven Glass
0012 6124              *
0013 6124              * Coding begin from version of the editLine custom control
0014 6124              * in the dialog manager.
0015 6124              *
0016 6124              * 01 Dec 88         Steven Glass
0017 6124              *
0018 6124              * The drawing routine now checks to see if the control is visible.
0019 6124              *
0020 6124              * 06 Feb 89         Harry Yee
0021 6124              *
0022 6124              * In do_draw routine, we now check if SpecialRect returns an error, if it does then
0023 6124              * I assume that the error is a dispatcher error, i.e. function not found as would be,
0024 6124              * in the case of pre-3.2 system disks, I then clean up the stack and call EraseRect and
0025 6124              * FrameRect instead. 
0026 6124              *
0027 6124              * 15 Feb 89         Harry Yee
0028 6124              *
0029 6124              * We now "include" LineEditEquates.asm. This holds the equates for line
0030 6124              * edit's direct page variables which we now need. In Do_Track when
0031 6124              * the control is being made active for the first time we now zero the ClickTime
0032 6124              * variable on direct page. This variable holds the last time that a mouse down
0033 6124              * occurred in a line edit control (any line edit control). Double/Triple clicks
0034 6124              * when clicking between several line edit controls now works. 
0035 6124              * BRC #38970.
0036 6124              *
0037 6124              * 10 Mar 89         Steven Glass
0038 6124              *
0039 6124              * Changed names associated with active controls to target controls.
0040 6124              *
0041 6124              * 15 Mar 89         Steven Glass
0042 6124              *
0043 6124              * Don't make control target if it is invisible.
0044 6124              *
0045 6124              * 24 Mar 89         Harry Yee
0046 6124              *
0047 6124              * Fixed problem in do_ChangeTarget, do_TakeTab, and do_TakeEvent. We were not checking 
0048 6124              * whether Target was visible or not before trying to deactivate it. Fixed.
0049 6124              *
0050 6124              * The lineEdit defprocs no longer call StartDrawing or SetOrigin(0,0). Its up to the
0051 6124              * program calling the defprocs to set the origin correctly (in this case TaskMaster).
0052 6124              *
0053 6124              * 28 Mar 89         Steven Glass
0054 6124              *
0055 6124              * Added support for the ctlWinStateChagne message.  Invalrect is called
0056 6124              * in response to this message so that the control will be redrawn.
0057 6124              *
0058 6124              *
0059 6124              * 12 Apr 89         Steven Glass
0060 6124              *
0061 6124              * Changed do_TakeEvent to reject events if control is inactive.
0062 6124              *
0063 6124              * 19 apr 89         Steven Glass
0064 6124              *
0065 6124              * Changed the init routine.  Could not handle initial value being
0066 6124              * a handle.
0067 6124              *
0068 6124              **********************************************************************
0069 6124
0070 6124                       blanks off 
0071 6124                       string asis 
0072 6124
0073 6124                       print push 
0074 6124                       print off 
0075 6124
0076 6124                       include 'all.macros' 
0077 6124                       include ':::ControlMgr:CtlCustomEqus.asm' 
0078 6124                       include 'e16.quickdraw' 
0079 6124                       include 'e16.font' 
0080 6124                       include 'e16.event' 
0081 6124                       include 'e16.resources' 
0082 6124                       include 'e16.lineedit' 
0083 6124                       include 'LineEditEquates.asm' 
0084 6124
0085 6124
0086 6124              True     equ $FFFF 
0087 6124              False    equ 0 
0088 6124
0089 6124              LineEditPartCode  equ $80 
0090 6124
0091 6124              y1       equ 0 
0092 6124              x1       equ 2 
0093 6124              y2       equ 4 
0094 6124              x2       equ 6 
0095 6124
0096 6124              TabKey   equ 9 
0097 6124              ReturnKey equ 13 
0098 6124
0099 6124
0100 6124                       print pop 
0101 6124
0102 6124
0103 6124                       title 'Proc Entry'
0104 6124
0105 6124              ;___________________________________________________________________________
0106 6124              ;
0107 6124              ;       LineEditProc
0108 6124              ;
0109 6124              ;       input: message:WORD - desired operation
0110 6124              ;              param:LONG - depends on operation
0111 6124              ;              ctlHandle:LONG - handle  to control
0112 6124              ;
0113 6124              ;      output: RetValue:LONG - depends on operation
0114 6124              ;____________________________________________________________________________
0115 6124
0116 6124              LineEditProc PROC 
0117 6124
0118 6124                       dsect 0 
0119 6124              ctlPtr   long 
0120 6124              Rect     block 8 
0121 6124              FontInfo block 8 
0122 6124              FontHeight word 
0123 6124              DestRect block 8 
0124 6124              SizeLocals DSectSize 
0125 6124
0126 6124 3B 38 E9 1E           link 10,SizeLocals
0127 612D
0128 612D                       DSect input 
0129 612D              ctlHandle long 
0130 612D              CtlParam long 
0131 612D              CtlMessage WORD 
0132 612D
0133 612D              RetValue equ output 
0134 612D
0135 612D              ;
0136 612D              ; Zeroes out RetValue
0137 612D              ;
0138 612D 64 2B                 stz   <RetValue
0139 612F 64 2D                 stz   <RetValue+2
0140 6131
0141 6131              ;
0142 6131              ; Check to see which message.  If it is the RecSize msg then
0143 6131              ; skip this part which sets port and origin since pointers
0144 6131              ; in control handle are not yet valid.
0145 6131              ;
0146 6131 A5 29                 lda   <CtlMessage
0147 6133 C9 0C 00              cmp   #RecSize
0148 6136 F0 1C                 beq   SkipThisShit
0149 6138              ;
0150 6138              ; Derefence Control Handle
0151 6138              ;
0152 6138 20 3B 66              jsr   DerefCtlHandle
0153 613B
0154 613B              ;
0155 613B              ; Get a copy of the enclosing rect
0156 613B              ;
0157 613B A0 08 00              ldy   #NewCtlRecord.ctlRect
0158 613E B7 00                 lda   [<ctlPtr],y
0159 6140 85 04                 sta   Rect
0160 6142 C8                    iny   
0161 6143 C8                    iny   
0162 6144 B7 00                 lda   [<ctlPtr],y
0163 6146 85 06                 sta   Rect+2
0164 6148 C8                    iny   
0165 6149 C8                    iny   
0166 614A B7 00                 lda   [<ctlPtr],y
0167 614C 85 08                 sta   Rect+4
0168 614E C8                    iny   
0169 614F C8                    iny   
0170 6150 B7 00                 lda   [<ctlPtr],y
0171 6152 85 0A                 sta   Rect+6
0172 6154
0173 6154
0174 6154              SkipThisShit  
0175 6154              ;
0176 6154              ; Dispatch
0177 6154              ;
0178 6154 A5 29                 lda   <CtlMessage
0179 6156 C9 14 00              cmp   #ctlWinStateChange+1
0180 6159 B0 05                 bcs   NotHandled
0181 615B 0A                    asl   a
0182 615C AA                    tax   
0183 615D FC 75 61              jsr   (CmdTable,x)
0184 6160
0185 6160              NotHandled  
0186 6160 2B A8 A3 20           unlink 
0187 6174
0188 6174 6B                    rtl                            ; quit procedure
0189 6175
0190 6175
0191 6175
0192 6175 9E 61        CmdTable DC W:Do_Draw                   0 DRAW
0193 6177 9D 61                 DC W:Do_Nothing                1 compute DragRect
0194 6179 48 62                 DC W:do_test                   2 common hit test
0195 617B F9 62                 DC W:Do_Init                   3 Init routine
0196 617D 33 65                 DC W:Do_Dispose                4 dispose routine
0197 617F 9D 61                 DC W:Do_Nothing                5 new value
0198 6181 9D 61                 DC W:Do_Nothing                6 thumb constraints
0199 6183 65 62                 DC W:Do_Track                  7 drag indicator
0200 6185 9D 61                 DC W:Do_Nothing                8 auto action proc
0201 6187 9E 61                 DC W:Do_Draw                   9 new value
0202 6189 9D 61                 DC W:Do_Nothing                10 set min/max
0203 618B 75 64                 DC W:Do_Move                   11 move control
0204 618D 0D 66                 DC W:Do_RecordSize             12 record size
0205 618F 6D 65                 DC W:Do_TakeEvent              13 take key or menu event
0206 6191 3E 65                 DC W:Do_TargetChange           14 Activity changed
0207 6193 9D 61                 DC W:do_nothing                15 Change Bounds
0208 6195 9D 61                 DC W:do_nothing                16 Window changed size
0209 6197 4E 62                 DC W:do_TakeTab                17 handle a tab
0210 6199 9D 61                 DC W:do_nothing                18 multi part event
0211 619B 13 66                 DC W:do_inval                  19 Winstate change
0212 619D
0213 619D              Do_Nothing  
0214 619D 60                    rts   
0215 619E
0216 619E
0217 619E                       title 'Do_Draw'
0218 619E              ****************************************************************
0219 619E              *
0220 619E              Do_Draw   
0221 619E              *
0222 619E              * Draws the LineEdit item in response to the control manager
0223 619E              * request.
0224 619E              *
0225 619E              * This draw routine, frames and erases the bounding rectangle
0226 619E              * and then calls LEUpdate.
0227 619E              *
0228 619E              *
0229 619E              * Inputs:
0230 619E              *                   param     PartCodeToDraw
0231 619E              *                   param+2   Hilite State
0232 619E              *
0233 619E              * Outputs:
0234 619E              *                   none
0235 619E              *
0236 619E              * External Refs:
0237 619E              *                   none
0238 619E              *
0239 619E              * Entry Points:
0240 619E              *                   none
0241 619E              *
0242 619E                       longa on                       ; mode
0243 619E                       longi on
0244 619E              *
0245 619E              ****************************************************************
0246 619E
0247 619E 20 24 66              jsr   CheckVis
0248 61A1 F0 01                 beq   @Continue
0249 61A3 60                    rts   
0250 61A4
0251 61A4              @continue  
0252 61A4              ;-----------------------------------------------------------
0253 61A4              ;
0254 61A4              ; Guarentee the text color
0255 61A4              ;
0256 61A4              ;-----------------------------------------------------------
0257 61A4 F4 00 00              pea   $0000
0258 61A7 A2 04 A0 22           _SetForeColor 
0259 61AE F4 FF FF              pea   $FFFF
0260 61B1 A2 04 A2 22           _SetBackColor 
0261 61B8
0262 61B8
0263 61B8 A5 27                 lda   ctlparam+2
0264 61BA F0 05                 beq   @WeAreTarget
0265 61BC
0266 61BC              ;-----------------------------------------------------------
0267 61BC              ;
0268 61BC              ; The control is "dim".  Do we think we are target?
0269 61BC              ; If yes, we must tell lineedit to untarget.
0270 61BC              ;
0271 61BC              ;-----------------------------------------------------------
0272 61BC              @WeAreNotTarget  
0273 61BC 20 62 65              jsr   DeActivate
0274 61BF 80 0D                 bra   @ok
0275 61C1
0276 61C1              ;-----------------------------------------------------------
0277 61C1              ;
0278 61C1              ; The control is not dim.  Do we think we are target?  If
0279 61C1              ; yes, we must tell line edit to activate.
0280 61C1              ;
0281 61C1              ;-----------------------------------------------------------
0282 61C1              @WeAreTarget  
0283 61C1 A0 3C 00              ldy   #NewCtlRecord.ctlMoreFlags
0284 61C4 B7 00                 lda   [ctlPtr],y
0285 61C6 29 00 80              and   #FctlTarget
0286 61C9 F0 F1                 beq   @WeAreNotTarget
0287 61CB
0288 61CB 20 57 65              jsr   Activate
0289 61CE
0290 61CE              @OK       
0291 61CE
0292 61CE              ;
0293 61CE              ; Draw EditLine enclosing rect
0294 61CE              ;
0295 61CE F4 00 00 7B           pushzptr <Rect 
0296 61D7 F4 00 00              PushWord #0 
0297 61DA F4 FF FF              PushWord #$FFFF 
0298 61DD A2 12 0C 22           _SpecialRect 
0299 61E4 90 57                 bcc   SpecialRectOK
0300 61E6
0301 61E6 3B                    tsc                            ; Fix stack from SpecialRect call
0302 61E7 18                    clc   
0303 61E8 69 08 00              adc   #8
0304 61EB 1B                    tcs   
0305 61EC
0306 61EC F4 00 00 7B           pushzptr <Rect                 ; Fill area we're going to frame with the background 
0307 61F5 A2 04 55 22           _EraseRect                     ; color
0308 61FC
0309 61FC A2 04 36 22           _PenNormal 
0310 6203
0311 6203 48                    pha                            ; width of pen depends on the mode we're in
0312 6204 A2 04 17 22           _GetMasterSCB 
0313 620B 68                    pla   
0314 620C 29 80 00              and   #$0080
0315 620F F0 05                 beq   In320
0316 6211
0317 6211 F4 02 00              pea   2                        ; pen width is 2 in 640 mode
0318 6214 80 03                 bra   PushHeight
0319 6216
0320 6216 F4 01 00     In320    pea   1                        ; pen width is 1 in 320 mode
0321 6219 F4 01 00     PushHeight pea   1                      ; pen height is 1
0322 621C A2 04 2C 22           _SetPenSize 
0323 6223
0324 6223 F4 00 00              pea   0                        ; set the pen pattern to be solid black
0325 6226 A2 04 37 22           _SetSolidPenPat 
0326 622D
0327 622D F4 00 00 7B           pushzptr <Rect                 ; frame the edit line item
0328 6236 A2 04 53 22           _FrameRect 
0329 623D
0330 623D              ;
0331 623D              ; ReDraws the Line by calling LineEdit
0332 623D              ;
0333 623D 20 2D 66     SpecialRectOK jsr   PushCtlData
0334 6240 A2 14 17 22           _LEUpdate 
0335 6247
0336 6247 60                    rts   
0337 6248
0338 6248
0339 6248                       title 'Do_Test'
0340 6248              ****************************************************************
0341 6248              *
0342 6248              Do_Test   
0343 6248              *
0344 6248              * Returns the part code for an indicator so that the defProc
0345 6248              * can do its own custom dragging.
0346 6248              *
0347 6248              *
0348 6248              * Inputs:
0349 6248              *                   none
0350 6248              *
0351 6248              * Outputs:
0352 6248              *                   none
0353 6248              *
0354 6248              * External Refs:
0355 6248              *                   none
0356 6248              *
0357 6248              * Entry Points:
0358 6248              *                   none
0359 6248              *
0360 6248                       longa on                       ; mode
0361 6248                       longi on
0362 6248              *
0363 6248              ****************************************************************
0364 6248
0365 6248 A9 80 00              lda   #LineEditPartCode
0366 624B 85 2B                 sta   <RetValue
0367 624D
0368 624D 60                    rts   
0369 624E
0370 624E                       title 'Do_Test'
0371 624E              ****************************************************************
0372 624E              *
0373 624E              Do_TakeTab  
0374 624E              *
0375 624E              * Selects the contents of the text.
0376 624E              *
0377 624E              *
0378 624E              * Inputs:
0379 624E              *                   none
0380 624E              *
0381 624E              * Outputs:
0382 624E              *                   none
0383 624E              *
0384 624E              * External Refs:
0385 624E              *                   none
0386 624E              *
0387 624E              * Entry Points:
0388 624E              *                   none
0389 624E              *
0390 624E                       longa on                       ; mode
0391 624E                       longi on
0392 624E              *
0393 624E              ****************************************************************
0394 624E
0395 624E 20 24 66              jsr   CheckVis
0396 6251 F0 01                 beq   @Continue
0397 6253 60                    rts   
0398 6254
0399 6254 F4 00 00     @Continue pushword #0                   ; select all the default text
0400 6257 F4 FF 7F              pushword #32767 
0401 625A 20 2D 66              jsr   PushCtlData
0402 625D A2 14 0E 22           _LESetSelect 
0403 6264
0404 6264 60                    rts   
0405 6265
0406 6265
0407 6265                       title 'Do_Track'
0408 6265              ****************************************************************
0409 6265              *
0410 6265              do_track  
0411 6265              *
0412 6265              * This is the routine that is called when the mouse goes down
0413 6265              * in the control.
0414 6265              *
0415 6265              * The control manager calls this routine because, the 
0416 6265              * test routine returned a part code of $80.
0417 6265              *
0418 6265              *
0419 6265              * Inputs:
0420 6265              *                   none
0421 6265              *
0422 6265              * Outputs:
0423 6265              *                   none
0424 6265              *
0425 6265              * External Refs:
0426 6265              *                   none
0427 6265              *
0428 6265              * Entry Points:
0429 6265              *                   none
0430 6265              *
0431 6265                       longa on                       ; mode
0432 6265                       longi on
0433 6265              *
0434 6265              ****************************************************************
0435 6265              ;-----------------------------------------------------------
0436 6265              ;
0437 6265              ; Look at the part code.  If it is zero, the whole control
0438 6265              ; wants to be dragged.
0439 6265              ;
0440 6265              ;-----------------------------------------------------------
0441 6265 A5 25                 lda   <CtlParam
0442 6267 D0 01                 bne   @GoOn
0443 6269 60                    rts   
0444 626A
0445 626A
0446 626A              @GoOn     
0447 626A
0448 626A              ;-----------------------------------------------------------
0449 626A              ;
0450 626A              ; Start by making this control Target.  To do so, we have
0451 626A              ; to see if we are already Target.
0452 626A              ;
0453 626A              ; If we are, then all is well, otherwise, we just have to
0454 626A              ; deactivate whoever and force a redraw.
0455 626A              ;
0456 626A              ;-----------------------------------------------------------
0457 626A
0458 626A A0 3C 00              ldy   #NewCtlRecord.CtlMoreFlags
0459 626D B7 00                 lda   [CtlPtr],y
0460 626F 29 00 80              and   #FCtlTarget
0461 6272 D0 2B                 bne   @AlreadyTarget
0462 6274
0463 6274              ;
0464 6274              ; --- This line edit control is being made Target for the first time ---------------
0465 6274              ;
0466 6274 F4 00 00              pea   0                        ; space for result
0467 6277 F4 00 00              pea   0
0468 627A F4 00 00              pea   0                        ; System toolset
0469 627D F4 14 00              pea   LETSNum                  ; Line Edit toolset number
0470 6280 A2 01 0C 22           _GetWAP 
0471 6287 FA                    plx   
0472 6288 68                    pla   
0473 6289 A9 00 00              lda   #0                       ; just in case its not on zero page
0474 628C 9F 4A 00 00           sta   >ClickTime,x             ; reset the last time mouse down happened to
0475 6290 9F 4C 00 00           sta   >ClickTime+2,x           ; zero, so double/triple clicks work correctly
0476 6294
0477 6294 D4 23                 pei   CtlHandle+2
0478 6296 D4 21                 pei   CtlHandle
0479 6298 A2 10 28 22           _MakeThisCtlTarget 
0480 629F
0481 629F              @AlreadyTarget  
0482 629F
0483 629F
0484 629F              ;-----------------------------------------------------------
0485 629F              ;
0486 629F              ; Now that the control is activated, we have to handle
0487 629F              ; the mouse down.  The tricky part here is that
0488 629F              ; we don't have the real event record.  What will
0489 629F              ; we do?
0490 629F              ;
0491 629F              ; We build a fake record on the stack.
0492 629F              ;
0493 629F              ;-----------------------------------------------------------
0494 629F
0495 629F                       DefineStack 
0496 629F              AnEventWhat         word   EQU   $00    ; Word - WmTaskRec -  
0497 629F              AnEventMessage      LONG   EQU   $02    ; Long - WmTaskRec -  
0498 629F              AnEventWhen         LONG   EQU   $06    ; Long - WmTaskRec -  
0499 629F              AnEventWhere        LONG   EQU   $0A    ; Point - WmTaskRec -  
0500 629F              AnEventModifiers    WORD   EQU   $0E    ; Word - WmTaskRec -  
0501 629F
0502 629F
0503 629F A9 00 00              lda   #0
0504 62A2 48                    pha                            ; mods
0505 62A3 48                    pha                            ; where
0506 62A4 48                    pha                            ; where
0507 62A5 48                    pha                            ; when
0508 62A6 48                    pha                            ; when
0509 62A7 48                    pha                            ; message
0510 62A8 48                    pha                            ; message
0511 62A9 48                    pha                            ; what
0512 62AA
0513 62AA 48                    pha   
0514 62AB 48                    pha   
0515 62AC 48                    pha   
0516 62AD A2 03 17 22           _ReadMouse 
0517 62B4 68                    pla   
0518 62B5 68                    pla   
0519 62B6 FA                    plx   
0520 62B7 83 0B                 sta   AnEventWhere,s
0521 62B9 8A                    txa   
0522 62BA 83 0D                 sta   AnEventWhere+2,s
0523 62BC
0524 62BC A9 01 00              lda   #1
0525 62BF 83 01                 sta   AnEventWhat,s
0526 62C1
0527 62C1 48                    pha   
0528 62C2 48                    pha   
0529 62C3 A2 06 10 22           _TickCount 
0530 62CA 68                    pla   
0531 62CB FA                    plx   
0532 62CC 83 07                 sta   AnEventWhen,s
0533 62CE 8A                    txa   
0534 62CF 83 09                 sta   AnEventWhen+2,s
0535 62D1
0536 62D1 A9 40 00              lda   #%0000000001000000
0537 62D4 83 0F                 sta   AnEventModifiers,s
0538 62D6
0539 62D6 3B                    tsc   
0540 62D7 1A                    inc   a
0541 62D8 F4 00 00              pea   $0000
0542 62DB 48                    pha   
0543 62DC
0544 62DC 20 2D 66              jsr   PushCtlData
0545 62DF A2 14 0D 22           _LEClick 
0546 62E6
0547 62E6 68                    pla                            ; what
0548 62E7 68                    pla                            ; message
0549 62E8 68                    pla                            ; message
0550 62E9 68                    pla                            ; when
0551 62EA 68                    pla                            ; when
0552 62EB 68                    pla                            ; where
0553 62EC 68                    pla                            ; where
0554 62ED 68                    pla                            ; modifiers
0555 62EE
0556 62EE A9 FF FF              lda   #True                    ; tell control manage that we handled the drag.
0557 62F1 85 2B                 sta   <RetValue
0558 62F3 A9 80 00              lda   #LineEditPartCode
0559 62F6 85 2D                 sta   <RetValue+2
0560 62F8
0561 62F8 60                    rts   
0562 62F9
0563 62F9                       title 'Do_Init'
0564 62F9              ****************************************************************
0565 62F9              *
0566 62F9              Do_Init   
0567 62F9              *
0568 62F9              * This is the hard working routine that takes the input from
0569 62F9              * the input template and builds the appropriate LineEdit
0570 62F9              * record.
0571 62F9              *
0572 62F9              *
0573 62F9              * Inputs:
0574 62F9              *                   ctlParam   pointer to template
0575 62F9              *                   ctlHandle  The control handle
0576 62F9              *                   ctlPtr     The control pointer
0577 62F9              *                   ctlRect    control's rectangle
0578 62F9              *
0579 62F9              * Outputs:
0580 62F9              *                   none
0581 62F9              *
0582 62F9              * External Refs:
0583 62F9                       import LoadResource 
0584 62F9                       import ReleaseResource 
0585 62F9              *
0586 62F9              * Entry Points:
0587 62F9              *                   none
0588 62F9              *
0589 62F9                       longa on                       ; mode
0590 62F9                       longi on
0591 62F9              *
0592 62F9              *
0593 62F9              * Change History
0594 62F9              *
0595 62F9              * 19 Apr 89         Steven Glass
0596 62F9              *
0597 62F9              * Could not pass the initial value by handle.  Was not setting
0598 62F9              * direct page up correctly.
0599 62F9              *
0600 62F9              ****************************************************************
0601 62F9
0602 62F9
0603 62F9
0604 62F9              ;-----------------------------------------------------------
0605 62F9              ;
0606 62F9              ; This is a line edit control so it can be Target and it
0607 62F9              ; can take key strokes.  So I force these bits on.
0608 62F9              ;
0609 62F9              ;-----------------------------------------------------------
0610 62F9 A0 3C 00              ldy   #NewCtlRecord.CtlMoreFlags
0611 62FC A9 00 60              lda   #FCtlCanBeTarget+FCtlWantEvents
0612 62FF 17 00                 ora   [CtlPtr],y
0613 6301 97 00                 sta   [CtlPtr],y
0614 6303
0615 6303
0616 6303              ;-----------------------------------------------------------
0617 6303              ;
0618 6303              ; LineEdit expects the current port to be the port
0619 6303              ; we will do the editing in.
0620 6303              ;
0621 6303              ;-----------------------------------------------------------
0622 6303
0623 6303 48                    pha                            ; save the current
0624 6304 48                    pha   
0625 6305 A2 04 1C 22           _GetPort 
0626 630C
0627 630C A0 06 00              ldy   #NewCtlRecord.ctlOwner+2
0628 630F B7 00                 lda   [ctlPtr],y
0629 6311 48                    pha   
0630 6312 88                    dey   
0631 6313 88                    dey   
0632 6314 B7 00                 lda   [ctlPtr],y
0633 6316 48                    pha   
0634 6317 A2 04 1B 22           _SetPort 
0635 631E
0636 631E              ;
0637 631E              ; Calculate the view rectangle
0638 631E              ;
0639 631E F4 00 00 7B           pushzptr Rect 
0640 6327 F4 02 00              pushword #2 
0641 632A F4 01 00              pushword #1 
0642 632D A2 04 4C 22           _InsetRect 
0643 6334
0644 6334              ;
0645 6334              ; Calculate the font height
0646 6334              ;
0647 6334 F4 00 00 7B           pushzptr FontInfo 
0648 633D A2 04 96 22           _GetFontInfo 
0649 6344
0650 6344 A5 0C                 lda   <FontInfo                ; ascent
0651 6346 18                    clc   
0652 6347 65 0E                 adc   <FontInfo+2              ; descent
0653 6349 65 12                 adc   <FontInfo+6              ; leading
0654 634B 85 14                 sta   <FontHeight
0655 634D
0656 634D              ;
0657 634D              ; Calculate how much the destRect must be inseted
0658 634D              ;
0659 634D A5 04                 lda   <Rect+0
0660 634F 85 16                 sta   <DestRect+0
0661 6351 A5 06                 lda   <Rect+2
0662 6353 85 18                 sta   <DestRect+2
0663 6355 A5 08                 lda   <Rect+4
0664 6357 85 1A                 sta   <DestRect+4
0665 6359 A5 0A                 lda   <Rect+6
0666 635B 85 1C                 sta   <DestRect+6
0667 635D
0668 635D A5 08                 lda   <Rect+y2                 ; inset = (viewRect.y2 - viewRect.y1
0669 635F 38                    sec                            ;         - FontHeight)/2
0670 6360 E5 04                 sbc   <Rect+y1
0671 6362 E5 14                 sbc   <FontHeight
0672 6364 4A                    lsr   a
0673 6365 AA                    tax   
0674 6366
0675 6366 F4 00 00 7B           pushzptr DestRect 
0676 636F F4 04 00              pushword #4                    ; horizontal inset = 4
0677 6372 DA                    phx                            ; vertical inset computed to center text
0678 6373 A2 04 4C 22           _InsetRect 
0679 637A
0680 637A              ;
0681 637A              ; Create the LineEdit Record
0682 637A              ;
0683 637A 48                    pha                            ; space for Line Edit Handle
0684 637B 48                    pha   
0685 637C F4 00 00 7B           pushzptr <DestRect 
0686 6385 F4 00 00 7B           pushzptr <Rect 
0687 638E A0 1A 00              ldy   #LineEditTemplate.MaxLen ; max length
0688 6391 B7 25                 lda   [<ctlParam],y
0689 6393 48                    pha   
0690 6394 A2 14 09 22           _LENew 
0691 639B
0692 639B 20 3B 66              jsr   DerefCtlHandle
0693 639E
0694 639E A0 1C 00              ldy   #NewCtlRecord.ctlData
0695 63A1 68                    pla   
0696 63A2 97 00                 sta   [<ctlPtr],y
0697 63A4 C8                    iny   
0698 63A5 C8                    iny   
0699 63A6 68                    pla   
0700 63A7 97 00                 sta   [<ctlPtr],y
0701 63A9              ;
0702 63A9              ; Test if TextPtr is Nil or not
0703 63A9              ;
0704 63A9 A0 1C 00              ldy   #LineEditTemplate.IVRef
0705 63AC B7 25                 lda   [<ctlParam],y
0706 63AE D0 09                 bne   DefaultText
0707 63B0 C8                    iny   
0708 63B1 C8                    iny   
0709 63B2 B7 25                 lda   [<ctlParam],y
0710 63B4 D0 03                 bne   DefaultText
0711 63B6
0712 63B6 82 91 00              brl   FinishUp
0713 63B9
0714 63B9              ;
0715 63B9              ; Set the edit text to the string passed as parameter
0716 63B9              ;
0717 63B9              DefaultText  
0718 63B9              ;
0719 63B9              ; Copy the reference to direct page in rect.
0720 63B9              ;
0721 63B9 A0 1C 00              ldy   #LineEditTemplate.IVRef
0722 63BC B7 25                 lda   [ctlParam],y
0723 63BE 85 04                 sta   rect
0724 63C0 C8                    iny   
0725 63C1 C8                    iny   
0726 63C2 B7 25                 lda   [ctlParam],y
0727 63C4 85 06                 sta   rect+2
0728 63C6
0729 63C6              ;
0730 63C6              ; look at the ref descriptor
0731 63C6              ;
0732 63C6 A0 3C 00              ldy   #NewCtlRecord.ctlMoreFlags
0733 63C9 B7 00                 lda   [ctlPtr],y
0734 63CB 29 03 00              and   #IVVerbMask
0735 63CE AA                    tax                            ; put copy here
0736 63CF F0 2A                 beq   @IsPtr
0737 63D1
0738 63D1 C9 01 00              cmp   #IVIsHandle
0739 63D4 F0 19                 beq   @ISHandle
0740 63D6
0741 63D6              ;
0742 63D6              ; load the resource
0743 63D6              ;
0744 63D6              @IsResource  
0745 63D6 48                    pha   
0746 63D7 48                    pha   
0747 63D8 F4 06 80              PushWord #rPString 
0748 63DB D4 06                 pei   rect+2
0749 63DD D4 04                 pei   rect
0750 63DF A2 10 32 22           _CMLoadResource 
0751 63E6 68                    pla   
0752 63E7 85 04                 sta   Rect
0753 63E9 68                    pla   
0754 63EA 85 06                 sta   Rect+2
0755 63EC
0756 63EC 20 3B 66              jsr   DerefCtlHandle
0757 63EF
0758 63EF              ;
0759 63EF              ; deref the handle
0760 63EF              ;
0761 63EF A7 04        @IsHandle lda   [Rect]
0762 63F1 AA                    tax   
0763 63F2 A0 02 00              ldy   #2
0764 63F5 B7 04                 lda   [Rect],y
0765 63F7 85 06                 sta   Rect+2
0766 63F9 86 04                 stx   Rect
0767 63FB
0768 63FB
0769 63FB              ;
0770 63FB              ; bump the pointer by 1 and call set text.
0771 63FB              ;
0772 63FB              @IsPtr    
0773 63FB A5 06                 lda   Rect+2
0774 63FD A6 04                 ldx   Rect
0775 63FF E8                    inx   
0776 6400 D0 01                 bne   @NoCarry
0777 6402 1A                    inc   a
0778 6403 48           @NoCarry pha   
0779 6404 DA                    phx   
0780 6405 A7 04                 lda   [Rect]
0781 6407 29 FF 00              and   #$00FF
0782 640A 48                    pha   
0783 640B 20 2D 66              jsr   PushCtlData
0784 640E A2 14 0B 22           _LESetText 
0785 6415
0786 6415 20 3B 66              jsr   DerefCtlHandle
0787 6418
0788 6418
0789 6418 F4 00 00              pushword #0                    ; select all the default text
0790 641B F4 FF 7F              pushword #32767 
0791 641E 20 2D 66              jsr   PushCtlData
0792 6421 A2 14 0E 22           _LESetSelect 
0793 6428
0794 6428
0795 6428 A0 3C 00              ldy   #NewCtlRecord.ctlMoreFlags
0796 642B B7 00                 lda   [ctlPtr],y
0797 642D 29 03 00              and   #IVVerbMask
0798 6430 C9 02 00              cmp   #IVIsResource
0799 6433 D0 15                 bne   FinishUp
0800 6435
0801 6435 F4 06 80              PushWord #rPString             ;was rString 19-Sep-90 DAL
0802 6438 A0 1E 00              ldy   #LineEditTemplate.IVRef+2
0803 643B B7 25                 lda   [<ctlParam],y
0804 643D 48                    pha   
0805 643E 88                    dey   
0806 643F 88                    dey   
0807 6440 B7 25                 lda   [<ctlParam],y
0808 6442 48                    pha   
0809 6443 A2 10 33 22           _CMReleaseResource 
0810 644A
0811 644A
0812 644A              FinishUp  
0813 644A
0814 644A              ;-----------------------------------------------------------
0815 644A              ;
0816 644A              ; Make this the Target control (unless the invis bit is set).
0817 644A              ;
0818 644A              ;-----------------------------------------------------------
0819 644A
0820 644A A0 10 00              ldy   #NewCtlRecord.CtlFlag
0821 644D B7 00                 lda   [<ctlPtr],y
0822 644F 29 80 00              and   #ctlInvis
0823 6452 D0 19                 bne   @DontMakeTarget
0824 6454
0825 6454 A2 04 27 22           _HidePen 
0826 645B
0827 645B D4 23                 pei   <CtlHandle+2             ; make this the Target control
0828 645D D4 21                 pei   <CtlHandle
0829 645F A2 10 28 22           _MakeThisCtlTarget 
0830 6466
0831 6466 A2 04 28 22           _ShowPen 
0832 646D
0833 646D              @DontMakeTarget  
0834 646D A2 04 1B 22           _SetPort                       Restore the current port.
0835 6474
0836 6474 60                    rts   
0837 6475
0838 6475
0839 6475
0840 6475                       title 'Do_Move'
0841 6475              ****************************************************************
0842 6475              *
0843 6475              Do_Move   
0844 6475              *
0845 6475              * This is the routine that adjusts the leRecord after the control
0846 6475              * has been moved.
0847 6475              *
0848 6475              *
0849 6475              * Inputs:
0850 6475              *                   ctlParam   delta Y and deltaX
0851 6475              *                   ctlHandle  The control handle
0852 6475              *                   ctlPtr     The control pointer
0853 6475              *                   ctlRect    control's new rectangle
0854 6475              *
0855 6475              * Outputs:
0856 6475              *                   none
0857 6475              *
0858 6475              * External Refs:
0859 6475                       import LoadResource 
0860 6475                       import ReleaseResource 
0861 6475              *
0862 6475              * Entry Points:
0863 6475              *                   none
0864 6475              *
0865 6475                       longa on                       ; mode
0866 6475                       longi on
0867 6475              *
0868 6475              ****************************************************************
0869 6475
0870 6475              ;
0871 6475              ; Save the port and set the port to the window.
0872 6475              ;
0873 6475
0874 6475 48                    pha                            ; save the current
0875 6476 48                    pha   
0876 6477 A2 04 1C 22           _GetPort 
0877 647E
0878 647E A0 06 00              ldy   #NewCtlRecord.ctlOwner+2
0879 6481 B7 00                 lda   [ctlPtr],y
0880 6483 48                    pha   
0881 6484 88                    dey   
0882 6485 88                    dey   
0883 6486 B7 00                 lda   [ctlPtr],y
0884 6488 48                    pha   
0885 6489 A2 04 1B 22           _SetPort 
0886 6490
0887 6490
0888 6490              ;
0889 6490              ; Calculate the view rectangle
0890 6490              ;
0891 6490 F4 00 00 7B           pushzptr Rect 
0892 6499 F4 02 00              pushword #2 
0893 649C F4 01 00              pushword #1 
0894 649F A2 04 4C 22           _InsetRect 
0895 64A6
0896 64A6              ;
0897 64A6              ; Calculate the font height
0898 64A6              ;
0899 64A6 F4 00 00 7B           pushzptr FontInfo 
0900 64AF A2 04 96 22           _GetFontInfo 
0901 64B6
0902 64B6 A5 0C                 lda   <FontInfo                ; ascent
0903 64B8 18                    clc   
0904 64B9 65 0E                 adc   <FontInfo+2              ; descent
0905 64BB 65 12                 adc   <FontInfo+6              ; leading
0906 64BD 85 14                 sta   <FontHeight
0907 64BF
0908 64BF              ;
0909 64BF              ; Calculate how much the destRect must be inseted
0910 64BF              ;
0911 64BF A5 04                 lda   <Rect+0
0912 64C1 85 16                 sta   <DestRect+0
0913 64C3 A5 06                 lda   <Rect+2
0914 64C5 85 18                 sta   <DestRect+2
0915 64C7 A5 08                 lda   <Rect+4
0916 64C9 85 1A                 sta   <DestRect+4
0917 64CB A5 0A                 lda   <Rect+6
0918 64CD 85 1C                 sta   <DestRect+6
0919 64CF
0920 64CF A5 08                 lda   <Rect+y2                 ; inset = (viewRect.y2 - viewRect.y1
0921 64D1 38                    sec                            ;         - FontHeight)/2
0922 64D2 E5 04                 sbc   <Rect+y1
0923 64D4 E5 14                 sbc   <FontHeight
0924 64D6 4A                    lsr   a
0925 64D7 AA                    tax   
0926 64D8
0927 64D8 F4 00 00 7B           pushzptr DestRect 
0928 64E1 F4 04 00              pushword #4                    ; horizontal inset = 4
0929 64E4 DA                    phx                            ; vertical inset computed to center text
0930 64E5 A2 04 4C 22           _InsetRect 
0931 64EC
0932 64EC
0933 64EC              OldLERec equ FontInfo 
0934 64EC
0935 64EC              ;
0936 64EC              ; Get the old LE Record handle and deref it
0937 64EC              ;
0938 64EC A0 1E 00              ldy   #NewCtlRecord.ctlData+2
0939 64EF B7 00                 lda   [<ctlPtr],y
0940 64F1 85 0E                 sta   OldLERec+2
0941 64F3 88                    dey   
0942 64F4 88                    dey   
0943 64F5 B7 00                 lda   [<ctlPtr],y
0944 64F7 85 0C                 sta   OldLERec
0945 64F9
0946 64F9
0947 64F9 A7 0C                 lda   [OldLERec]
0948 64FB AA                    tax   
0949 64FC A0 02 00              ldy   #2
0950 64FF B7 0C                 lda   [OldLERec],y
0951 6501 85 0E                 sta   OldLERec+2
0952 6503 86 0C                 stx   OldLERec
0953 6505
0954 6505              ;
0955 6505              ; Copy the DestRect into the LE record
0956 6505              ;
0957 6505 A0 08 00              ldy   #oleDestRect
0958 6508 A2 00 00              ldx   #0
0959 650B B5 16        @Loop1   lda   DestRect,x
0960 650D 97 0C                 sta   [OldLERec],y
0961 650F C8                    iny   
0962 6510 C8                    iny   
0963 6511 E8                    inx   
0964 6512 E8                    inx   
0965 6513 E0 08 00              cpx   #8
0966 6516 90 F3                 bcc   @Loop1
0967 6518
0968 6518              ;
0969 6518              ; Copy the ViewRect into the LERecord
0970 6518              ;
0971 6518 A0 10 00              ldy   #oleViewRect
0972 651B A2 00 00              ldx   #0
0973 651E B5 04        @Loop2   lda   Rect,x
0974 6520 97 0C                 sta   [OldLERec],y
0975 6522 C8                    iny   
0976 6523 C8                    iny   
0977 6524 E8                    inx   
0978 6525 E8                    inx   
0979 6526 E0 08 00              cpx   #8
0980 6529 90 F3                 bcc   @Loop2
0981 652B
0982 652B
0983 652B A2 04 1B 22           _SetPort 
0984 6532
0985 6532 60                    rts   
0986 6533
0987 6533
0988 6533                       title 'Do_Dispose'
0989 6533              ****************************************************************
0990 6533              *
0991 6533              Do_Dispose                              ; 
0992 6533              *
0993 6533              * Disposes of the LE record when the control record is 
0994 6533              * being killed.
0995 6533              *
0996 6533              *
0997 6533              * Inputs:
0998 6533              *                   none
0999 6533              *
1000 6533              * Outputs:
1001 6533              *                   none
1002 6533              *
1003 6533              * External Refs:
1004 6533              *                   none
1005 6533              *
1006 6533              * Entry Points:
1007 6533              *                   none
1008 6533              *
1009 6533                       longa on                       ; mode
1010 6533                       longi on
1011 6533              *
1012 6533              ****************************************************************
1013 6533
1014 6533 20 2D 66              jsr   PushCtlData
1015 6536 A2 14 0A 22           _LEDispose 
1016 653D
1017 653D 60                    rts   
1018 653E
1019 653E
1020 653E                       title 'Do_TargetChange'
1021 653E              ****************************************************************
1022 653E              *
1023 653E              Do_TargetChange  
1024 653E              *
1025 653E              * This is the little routine is called when the ChangeTarget
1026 653E              * message is called.
1027 653E              *
1028 653E              *
1029 653E              * Inputs:
1030 653E              *                   ctlHandle   Control's handle
1031 653E              *                   ctlPtr      (Handle derefed)
1032 653E              *                   ctlParam    not used
1033 653E              *
1034 653E              * Outputs:
1035 653E              *                   none
1036 653E              *
1037 653E              * External Refs:
1038 653E              *                   none
1039 653E              *
1040 653E              * Entry Points:
1041 653E              *                   none
1042 653E              *
1043 653E                       longa on                       ; mode
1044 653E                       longi on
1045 653E              *
1046 653E              ****************************************************************
1047 653E
1048 653E 20 24 66              jsr   CheckVis
1049 6541 F0 01                 beq   @Continue
1050 6543 60                    rts   
1051 6544
1052 6544 A0 3C 00     @Continue ldy   #NewCtlRecord.ctlMoreFlags
1053 6547 B7 00                 lda   [ctlPtr],y
1054 6549 29 00 80              and   #FCtlTarget
1055 654C F0 05                 beq   @Deactivate
1056 654E
1057 654E 20 57 65              jsr   Activate
1058 6551 80 03                 bra   @Fini
1059 6553
1060 6553
1061 6553 20 62 65     @Deactivate jsr   Deactivate
1062 6556
1063 6556 60           @Fini    rts   
1064 6557
1065 6557              Activate  
1066 6557 20 2D 66              jsr   PushCtlData
1067 655A A2 14 0F 22           _LEActivate 
1068 6561 60                    rts   
1069 6562
1070 6562 20 2D 66     Deactivate jsr   PushCtlData
1071 6565 A2 14 10 22           _LEDeactivate 
1072 656C 60                    rts   
1073 656D
1074 656D
1075 656D
1076 656D                       title 'Do_TakeEvent'
1077 656D              ****************************************************************
1078 656D              *
1079 656D              Do_TakeEvent  
1080 656D              *
1081 656D              * This is the little routine that handles key strokes, menu
1082 656D              * events and idle events.
1083 656D              *
1084 656D              *
1085 656D              * Inputs:
1086 656D              *                   ctlHandle   Control's handle
1087 656D              *                   ctlPtr      (Handle derefed)
1088 656D              *                   ctlParam    pointer to task record
1089 656D              *
1090 656D              * Outputs:
1091 656D              *                   retValue is true indicating we took the event
1092 656D              *
1093 656D              * External Refs:
1094 656D              *                   none
1095 656D              *
1096 656D              * Entry Points:
1097 656D              *                   none
1098 656D              *
1099 656D                       longa on                       ; mode
1100 656D                       longi on
1101 656D              *
1102 656D              *
1103 656D              * Change History
1104 656D              *
1105 656D              * 06 Jan 88         Steven Glass
1106 656D              *
1107 656D              * Added code to look at the modifiers.  If apple key is down,
1108 656D              * we ignore the key stroke unless it is an arrow key.
1109 656D              *
1110 656D              * 12 Apr 89         Steven Glass
1111 656D              *
1112 656D              * Check hilite flag and reject event if ctl is inactive.
1113 656D              *
1114 656D              ****************************************************************
1115 656D
1116 656D 20 24 66              jsr   CheckVis
1117 6570 F0 01                 beq   @Continue
1118 6572 60                    rts   
1119 6573
1120 6573              @continue  
1121 6573
1122 6573              ; Added 12 Apr 89 SEG
1123 6573 A0 10 00              ldy   #NewCtlRecord.ctlFlag    Look at the flag and hilite
1124 6576 B7 00                 lda   [<ctlPtr],y              bytes.  If hilite is FF
1125 6578 29 00 FF              and   #$FF00                   we are inactive and should
1126 657B C9 00 FF              cmp   #$FF00                   ignore the event.
1127 657E F0 1E                 beq   @RejectEvent
1128 6580              ; End Addition
1129 6580
1130 6580 A7 25                 lda   [ctlParam]
1131 6582 D0 10                 bne   @NotNull
1132 6584
1133 6584 20 2D 66              jsr   PushCtlData
1134 6587 A2 14 0C 22           _LEIdle 
1135 658E
1136 658E A9 FF FF              lda   #True
1137 6591 82 4B 00              brl   @Fini
1138 6594
1139 6594              @NotNull  
1140 6594 C9 03 00              cmp   #keyDownEvt
1141 6597 F0 0A                 beq   @IsKey
1142 6599
1143 6599 C9 05 00              cmp   #AutoKeyEvt
1144 659C F0 05                 beq   @IsKey
1145 659E
1146 659E A9 00 00     @RejectEvent lda   #False
1147 65A1 80 3C                 bra   @Fini
1148 65A3
1149 65A3              @IsKey    
1150 65A3              ;
1151 65A3              ; If the apple key is down only accept the arrow keys, otherwise
1152 65A3              ; reject the key.
1153 65A3              ;
1154 65A3
1155 65A3 A0 0E 00              ldy   #oModifiers
1156 65A6 B7 25                 lda   [ctlParam],y
1157 65A8 29 00 01              and   #appleKey
1158 65AB F0 0F                 beq   @NotModified
1159 65AD
1160 65AD A0 02 00              ldy   #oMessage
1161 65B0 B7 25                 lda   [ctlParam],y
1162 65B2 C9 08 00              cmp   #8                       ; left arrow
1163 65B5 F0 05                 beq   @NotModified
1164 65B7 C9 15 00              cmp   #$15                     ; right arrow
1165 65BA D0 E2                 bne   @RejectEvent
1166 65BC              @NotModified  
1167 65BC
1168 65BC A0 02 00              ldy   #oMessage
1169 65BF B7 25                 lda   [ctlParam],y
1170 65C1 C9 09 00              cmp   #TabKey
1171 65C4 F0 1C                 beq   @HandleTab
1172 65C6 C9 0D 00              cmp   #ReturnKey
1173 65C9 F0 D3                 beq   @RejectEvent
1174 65CB 48                    pha   
1175 65CC A0 0E 00              ldy   #oModifiers
1176 65CF B7 25                 lda   [ctlParam],y
1177 65D1 48                    pha   
1178 65D2 20 2D 66              jsr   PushCtlData
1179 65D5 A2 14 11 22           _LEKey 
1180 65DC
1181 65DC A9 FF FF     @TakeIt  lda   #True
1182 65DF 85 2B        @Fini    sta   <RetValue
1183 65E1 60                    rts   
1184 65E2
1185 65E2              ;-----------------------------------------------------------
1186 65E2              ;
1187 65E2              ; We have a tab, so we try to make the next control Target.
1188 65E2              ; If we are the only control, we end up ignoring the tab.
1189 65E2              ; If we are not the only control, we send the 
1190 65E2              ; ctlHandleTab message to the newly Target control
1191 65E2              ;
1192 65E2              ;-----------------------------------------------------------
1193 65E2 48           @HandleTab pha                          ; make the next one Target
1194 65E3 48                    pha   
1195 65E4 A2 10 27 22           _MakeNextCtlTarget 
1196 65EB 68                    pla   
1197 65EC FA                    plx   
1198 65ED C5 21                 cmp   ctlHandle                ; is it us?
1199 65EF D0 04                 bne   @NotSame                 ; no
1200 65F1 E4 23                 cpx   ctlHandle+2
1201 65F3 F0 E7                 beq   @TakeIt                  ; yes
1202 65F5
1203 65F5              @NotSame                                ; no
1204 65F5 48                    pha                            ; Call the new one.
1205 65F6 48                    pha   
1206 65F7 DA                    phx   
1207 65F8 48                    pha   
1208 65F9 F4 11 00              PushWord #ctlHandleTab 
1209 65FC F4 00 00 F4           PushLong #0 
1210 6602 A2 10 2C 22           _CallCtlDefProc 
1211 6609 68                    pla   
1212 660A 68                    pla   
1213 660B
1214 660B 80 CF                 bra   @TakeIt
1215 660D
1216 660D
1217 660D                       title 'Do_RecordSize'
1218 660D              ****************************************************************
1219 660D              *
1220 660D              Do_RecordSize  
1221 660D              *
1222 660D              * Returns the size of the control record that we need.
1223 660D              *
1224 660D              *
1225 660D              * Inputs:
1226 660D              *                   none
1227 660D              *
1228 660D              * Outputs:
1229 660D              *                   none
1230 660D              *
1231 660D              * External Refs:
1232 660D              *                   none
1233 660D              *
1234 660D              * Entry Points:
1235 660D              *                   none
1236 660D              *
1237 660D                       longa on                       ; mode
1238 660D                       longi on
1239 660D              *
1240 660D              ****************************************************************
1241 660D
1242 660D A9 40 00              lda   #SuperCtlSize
1243 6610 85 2B                 sta   <RetValue
1244 6612
1245 6612 60                    rts   
1246 6613
1247 6613
1248 6613                       title 'Do_Inval'
1249 6613              ****************************************************************
1250 6613              *
1251 6613              Do_Inval  
1252 6613              *
1253 6613              * Invalidates the control record in response to a window state
1254 6613              * change message.
1255 6613              *
1256 6613              *
1257 6613              * Inputs:
1258 6613              *                   none
1259 6613              *
1260 6613              * Outputs:
1261 6613              *                   none
1262 6613              *
1263 6613              * External Refs:
1264 6613              *                   none
1265 6613              *
1266 6613              * Entry Points:
1267 6613              *                   none
1268 6613              *
1269 6613                       longa on                       ; mode
1270 6613                       longi on
1271 6613              *
1272 6613              ****************************************************************
1273 6613
1274 6613 F4 00 00 7B           PushZPtr Rect 
1275 661C A2 0E 3A 22           _InvalRect 
1276 6623
1277 6623 60                    rts   
1278 6624
1279 6624
1280 6624
1281 6624
1282 6624                       title 'Utilities'
1283 6624              **********************************************************************
1284 6624              *
1285 6624              * Various Utilities
1286 6624              *
1287 6624              **********************************************************************
1288 6624
1289 6624
1290 6624 A0 10 00     CheckVis ldy   #NewCtlRecord.ctlFlag    ; make sure we are visible
1291 6627 B7 00                 lda   [ctlPtr],y               ; before we draw.
1292 6629 29 80 00              and   #ctlInVis
1293 662C 60                    rts   
1294 662D
1295 662D
1296 662D
1297 662D FA           PushCtlData plx   
1298 662E A0 1E 00              ldy   #NewCtlRecord.ctlData+2
1299 6631 B7 00                 lda   [<ctlPtr],y
1300 6633 48                    pha   
1301 6634 88                    dey   
1302 6635 88                    dey   
1303 6636 B7 00                 lda   [<ctlPtr],y
1304 6638 48                    pha   
1305 6639 DA                    phx   
1306 663A 60                    rts   
1307 663B
1308 663B
1309 663B A7 21        DerefCtlHandle lda   [<ctlHandle]
1310 663D 85 00                 sta   <ctlPtr
1311 663F A0 02 00              ldy   #2
1312 6642 B7 21                 lda   [<ctlHandle],y
1313 6644 85 02                 sta   <ctlPtr+2
1314 6646 60                    rts   
1315 6647
1316 6647                       ENDP 
1317 6647
1318 6647
1319 6647              ****************************************************************
1320 6647              *
1321 6647              GetLEDefProc PROC Export 
1322 6647              *
1323 6647              * Returns the address of the LineEdit control def-proc.
1324 6647              *
1325 6647              *
1326 6647              * Inputs:
1327 6647              *                   space for pointer
1328 6647              *
1329 6647              * Outputs:
1330 6647              *                   Pointer to DefProc
1331 6647              *
1332 6647              * External Refs:
1333 6647                       import LineEditProc 
1334 6647              *
1335 6647              * Entry Points:
1336 6647              *                   none
1337 6647              *
1338 6647                       longa on                       ; mode
1339 6647                       longi on
1340 6647              *
1341 6647              ****************************************************************
1342 6647
1343 6647
1344 6647                       DefineStack 
1345 6647              RTL1     block 3 
1346 6647              RTL2     block 3 
1347 6647              ThePointer LONG 
1348 6647
1349 6647 A9 24 61              lda   #LineEditProc
1350 664A 83 07                 sta   ThePointer,s
1351 664C A9 FC 00              lda   #^LineEditProc
1352 664F 83 09                 sta   ThePointer+2,s
1353 6651
1354 6651 A9 00 00              lda   #0
1355 6654 18                    clc   
1356 6655 6B                    rtl   
1357 6656
1358 6656                       ENDP 
1359 6656
1360 6656                       END   
